/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: PlatformLayerWin32.cpp                                             *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              22/06/2007       1.0                              *
*******************************************************************************/

#include "PlatformLayerWin32.h"
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <initguid.h>
#include <windows.h>
#include <setupapi.h>
#include <usbioctl.h>

platformLayerWin32::platformLayerWin32() {

    platform = 1;
    vid = (short)0x04d8;
    pid = (short)0x000c;
    findDevices();
}

platformLayerWin32::~platformLayerWin32() {

    l->printLog("platformLayerWin32 Destructor",true,true);
    l = NULL;
}

void platformLayerWin32::findDevices() {

    int board = 0;
    HANDLE hnd, hnd2;
    DWORD j, i = 0, len, ret;
    HDEVINFO h;
    SP_DEVICE_INTERFACE_DATA didata;
    PSP_DEVICE_INTERFACE_DETAIL_DATA diddata;
    USB_ROOT_HUB_NAME name;
    PUSB_ROOT_HUB_NAME pname = NULL;
    PUSB_NODE_INFORMATION nodeinfo;
    PUSB_NODE_CONNECTION_INFORMATION nodecon;

    h = SetupDiGetClassDevs((LPGUID)&GUID_CLASS_USB_HOST_CONTROLLER,NULL,NULL,(DIGCF_PRESENT|DIGCF_DEVICEINTERFACE));
    if(h != INVALID_HANDLE_VALUE) {
        didata.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
        for (i=0; SetupDiEnumDeviceInterfaces(h,0,(LPGUID)&GUID_CLASS_USB_HOST_CONTROLLER,i,&didata) ; i++) {
            SetupDiGetDeviceInterfaceDetail(h, &didata, NULL, 0, &len, NULL);
            diddata = (PSP_DEVICE_INTERFACE_DETAIL_DATA) (new char[len]);
            diddata->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
            if (SetupDiGetDeviceInterfaceDetail(h, &didata, diddata, len, &len, NULL)) {
                hnd = CreateFile(diddata->DevicePath, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
                if (hnd != INVALID_HANDLE_VALUE) {
                    if (DeviceIoControl(hnd, IOCTL_USB_GET_ROOT_HUB_NAME, 0, 0, &name, sizeof(name), &len, NULL)) {
                        len = name.ActualLength;
                        pname = (PUSB_ROOT_HUB_NAME) (new char[len]);
                        if (DeviceIoControl(hnd, IOCTL_USB_GET_ROOT_HUB_NAME, NULL, 0, pname, len, &len, NULL)) {
                            len = wcstombs(NULL, pname->RootHubName, BUFFER_SIZE);
                            char rhname[BUFFER_SIZE] = "\\\\.\\";
                            wcstombs (&rhname[4], pname->RootHubName, len);
                            hnd2 = CreateFile(rhname, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
                            if (hnd2 != INVALID_HANDLE_VALUE) {
                                nodeinfo = (PUSB_NODE_INFORMATION) (new char[sizeof(USB_NODE_INFORMATION)]);
                                if (DeviceIoControl(hnd2, IOCTL_USB_GET_NODE_INFORMATION, nodeinfo, sizeof(USB_NODE_INFORMATION), nodeinfo, sizeof(USB_NODE_INFORMATION), &ret, NULL)) {
                                    for (j = 1; j <= nodeinfo->u.HubInformation.HubDescriptor.bNumberOfPorts; j++) {
                                        len = sizeof(USB_NODE_CONNECTION_INFORMATION) + (sizeof(USB_PIPE_INFO) * 30);
                                        nodecon = (PUSB_NODE_CONNECTION_INFORMATION) (new char[len]);
                                        nodecon->ConnectionIndex = j;
                                        if (DeviceIoControl(hnd2, IOCTL_USB_GET_NODE_CONNECTION_INFORMATION, nodecon, len, nodecon, len, &ret, NULL)) {
                                            if ((nodecon->DeviceDescriptor.idVendor == vid) && (nodecon->DeviceDescriptor.idProduct == pid)) {
                                                itemDsc idsc;
                                                UCHAR buf[sizeof(USB_DESCRIPTOR_REQUEST) + MAXIMUM_USB_STRING_LENGTH];
                                                PUSB_DESCRIPTOR_REQUEST request;
                                                PUSB_STRING_DESCRIPTOR  strdesc;
                                                PCHAR dsc;

                                                memcpy(&idsc.rhubname[0], &rhname[0], BUFFER_SIZE);
                                                idsc.port = (int)j;
                                                len = sizeof(buf);
                                                request = (PUSB_DESCRIPTOR_REQUEST)buf;
                                                strdesc = (PUSB_STRING_DESCRIPTOR)(request+1);
                                                // iManufacturer
                                                if (nodecon->DeviceDescriptor.iManufacturer > 0) {
                                                    memset(request, 0, len);
                                                    request->ConnectionIndex = j;
                                                    request->SetupPacket.wValue = (USB_STRING_DESCRIPTOR_TYPE << 8) | nodecon->DeviceDescriptor.iManufacturer;
                                                    request->SetupPacket.wIndex = (USHORT)0x0409;
                                                    request->SetupPacket.wLength = (USHORT)(len - sizeof(USB_DESCRIPTOR_REQUEST));
                                                    if (DeviceIoControl(hnd2, IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, request, len, request, len, &ret, NULL)) {
                                                        dsc = new char[strdesc->bLength-2];
                                                        wcstombs (dsc, strdesc->bString, strdesc->bLength-2);
                                                        memcpy(&idsc.strManufacturer[0], dsc, strdesc->bLength-2);
                                                        delete [] dsc;
                                                    }
                                                }
                                                // iProduct
                                                if (nodecon->DeviceDescriptor.iProduct > 0) {
                                                    memset(request, 0, len);
                                                    request->ConnectionIndex = j;
                                                    request->SetupPacket.wValue = (USB_STRING_DESCRIPTOR_TYPE << 8) | nodecon->DeviceDescriptor.iProduct;
                                                    request->SetupPacket.wIndex = (USHORT)0x0409;
                                                    request->SetupPacket.wLength = (USHORT)(len - sizeof(USB_DESCRIPTOR_REQUEST));
                                                    if (DeviceIoControl(hnd2, IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, request, len, request, len, &ret, NULL)) {
                                                        dsc = new char[strdesc->bLength-2];
                                                        wcstombs (dsc, strdesc->bString, strdesc->bLength-2);
                                                        memcpy(&idsc.strProduct[0], dsc, strdesc->bLength-2);
                                                        memcpy(&idsc.strSerialNumber[0], dsc, strdesc->bLength-2);
                                                        delete [] dsc;
                                                    }
                                                }
                                                // iSerialNumber
                                                if (nodecon->DeviceDescriptor.iSerialNumber > 0) {
                                                    memset(request, 0, len);
                                                    request->ConnectionIndex = j;
                                                    request->SetupPacket.wValue = (USB_STRING_DESCRIPTOR_TYPE << 8) | nodecon->DeviceDescriptor.iSerialNumber;
                                                    request->SetupPacket.wIndex = (USHORT)0x0409;
                                                    request->SetupPacket.wLength = (USHORT)(len - sizeof(USB_DESCRIPTOR_REQUEST));
                                                    if (DeviceIoControl(hnd2, IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, request, len, request, len, &ret, NULL)) {
                                                        dsc = new char[strdesc->bLength-2];
                                                        wcstombs (dsc, strdesc->bString, strdesc->bLength-2);
                                                        memcpy(&idsc.strSerialNumber[0], dsc, strdesc->bLength-2);
                                                        delete [] dsc;
                                                    }
                                                }
                                                findEndpoints((int) hnd2,idsc);
                                                descriptors.insert(pair<int,itemDsc>(board,idsc));
                                                board++;
                                            } // vid-pid
                                        } // IOCTL_USB_GET_NODE_CONNECTION_INFORMATION
                                        PCHAR temp;
                                        temp = (PCHAR) nodecon;
                                        delete [] temp;
                                    } // Numbs Ports
                                } // IOCTL_USB_GET_NODE_INFORMATION
                                PCHAR temp;
                                temp = (PCHAR) nodeinfo;
                                delete [] temp;
                            } // hnd2
                            CloseHandle(hnd2);
                        } // IOCTL_USB_GET_ROOT_HUB_NAME
                        PCHAR temp;
                        temp = (PCHAR) pname;
                        delete [] temp;
                    } //IOCTL_USB_GET_ROOT_HUB_NAME
                } // hnd
                CloseHandle(hnd);
            } // SetupDiGetDeviceInterfaceDetail
            PCHAR temp;
            temp = (PCHAR) diddata;
            delete [] temp;
        } // for
    } // h
	SetupDiDestroyDeviceInfoList(h);
}

void platformLayerWin32::findEndpoints(int h, itemDsc &idsc) {

    DWORD len, ret;
    UCHAR buf[sizeof(USB_DESCRIPTOR_REQUEST) + sizeof(USB_CONFIGURATION_DESCRIPTOR)];
    PUSB_DESCRIPTOR_REQUEST request;
    PUSB_CONFIGURATION_DESCRIPTOR cfgdesc;

    len = sizeof(buf);
    request = (PUSB_DESCRIPTOR_REQUEST)buf;
    cfgdesc = (PUSB_CONFIGURATION_DESCRIPTOR)(request+1);
    memset(request, 0, len);
    request->ConnectionIndex = idsc.port;
    request->SetupPacket.wValue = (USB_CONFIGURATION_DESCRIPTOR_TYPE << 8) | (UCHAR)0;
    request->SetupPacket.wLength = (USHORT)(len - sizeof(USB_DESCRIPTOR_REQUEST));
    if (DeviceIoControl((HANDLE)h, IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, request, len, request, len, &ret, NULL)) {
        len = sizeof(USB_DESCRIPTOR_REQUEST) + cfgdesc->wTotalLength;
        request = (PUSB_DESCRIPTOR_REQUEST) (new char[len]);
        cfgdesc = (PUSB_CONFIGURATION_DESCRIPTOR)(request+1);
        request->ConnectionIndex = idsc.port;
        request->SetupPacket.wValue = (USB_CONFIGURATION_DESCRIPTOR_TYPE << 8) | (UCHAR)0;
        request->SetupPacket.wLength = (USHORT)(len - sizeof(USB_DESCRIPTOR_REQUEST));
        if (DeviceIoControl((HANDLE)h, IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, request, len, request, len, &ret, NULL)) {
            for (int i = 0; i < 9; i++) {
                idsc.stdConfigurationDsc[i] = request->Data[i];
                idsc.stdInterfaceDsc[i] = request->Data[i+9];
            }
            idsc.qtyep = (int) idsc.stdInterfaceDsc[4];
            for (int i = 0 ; i < idsc.qtyep ; i++) {
                for (int j = 0 ; j < 7 ; j++) {
                    idsc.stdEndpointDsc[i][j] = request->Data[18+j+(i*7)];
                }
            }
        }
        PCHAR temp;
        temp = (PCHAR) request;
        delete [] temp;
    }
}

map<int,itemDsc> platformLayerWin32::getDescriptors() {

    return descriptors;
}
